//de Setpoint para el controlador PID. El encoder del motor es el Input del PID
//Para ajustar el rango del PWM "PID_v1->PID::SetOutputLimits" al rededor de 160 se empieza a mover

#include <ESP32Encoder.h>
#include "Librerias.h"

system_t sys;   //Estructura definida en Globales.h que contiene los variables del programa que se graba en la Eeprom 

typedef union //Unión para conversión de float a byte
{
  float number;
  uint8_t bytes[4];
} FLOATUNION_t;

//Variables a recibir de simulink
FLOATUNION_t ValorPIDSimulink;
FLOATUNION_t ReferenciaTension;
FLOATUNION_t ElegirEntradas; //Elegir las entradas de simulink o las de la maqueta

//Variables enviadas por la ESP32
FLOATUNION_t SIM_Tiempo;
FLOATUNION_t SIM_TipoControl;
FLOATUNION_t SIM_TipoPID;
FLOATUNION_t SIM_Encoder;
//FLOATUNION_t SIM_PIDSalida;
FLOATUNION_t SIM_Corriente;
FLOATUNION_t SIM_Tension;
FLOATUNION_t SIM_TorqueCarga;

String stringEstado[]={"MARCHA","PARO"};
String stringControl[]={"VELOC","POSIC"};
String stringEntrada[]={"ESCALON","SENO","CONST","RAMPA"};
String stringPID[]={"LOCAL","SIMULINK","IDENTIFICACION"};

// Motor
#define encoderA 34 
#define encoderB 35
#define LOCAL 16
#define SIMULINK 17
#define EnableVent 33 //Control PWM para el segundo motor (Configurado para la refrigeración de la maqueta en caso de ser necesario)
#define CorrienteOpAmp 12    //Valor de corriente amplificado (x45 veces) //44K, 1K --> G = ((44K/1K)+1) = 45
#define CorrienteShunt 14    //Medida sin amplificar de la corriente (desde el emisor de los transistores del puente H)

ESP32Encoder myEnc;

const float SHUNT_OHMIOS = 1.2;    // Valor de la resistencia shunt (Ω)
const float GANANCIA = 41.25;     // Ganancia del amplificador LM358
const float VREF = 3.3;          // Voltaje de referencia del ADC
const int ADC_MAX = 4095;        // Resolución del ADC (12 bits ESP32)

int test_limits = 2; // De rotary Encoder
const int PPR = 22*34; //22 pulsos por revolución, multiplicado por la reductora 1:34
double Kp, Ki, Kd;
double Setpoint, Input, Output; 
double velMotor;
int tensionAnterior;
float tension;
float tactual, tanterior, t0, temp, t_freno;

int boton_pulsado=0;
//int estado=PARO;

bool getFloats()
{
  // Esperar a que haya al menos 13 bytes disponibles
  if (Serial.available() >= 13) 
  {
    if (Serial.read() != 'B')//Comprobar que se están recibiendo datos de Simulink
    {
      return false;
    }
    else
    {
      tanterior = tactual;
    }
    // Leer 4 bytes del primer float
    for (int i = 0; i < 4; i++) 
    {
      ReferenciaTension.bytes[i] = Serial.read();
    }
    // Leer 4 bytes del segundo float
    for (int i = 0; i < 4; i++) 
    {
      ValorPIDSimulink.bytes[i] = Serial.read();
    }
    // Leer 4 bytes del tercer float
    for (int i = 0; i < 4; i++) 
    {
      ElegirEntradas.bytes[i] = Serial.read();
    }
    return true;
  }
  return false;  //No había suficientes datos
}

PID myPID(&Input, &Output, &Setpoint, Kp, Ki, Kd, DIRECT);

void controlVelocidad();
void controlPosicion();
double  move(double xd, double vmax, double a, double dt);

void setup() 
{
  settingsLoadFromEEprom();
  analogReadResolution(12);//Aumentamos la resolución a 2^12 --> 4096 estados
  //analogSetPinAttenuation(CorrienteMotor, ADC_0db);//Reducimos el filtrado de la señal para abarcar un rango más amplio de recepción (corriente del motor)
  analogSetPinAttenuation(CorrienteShunt, ADC_11db);
  analogSetPinAttenuation(CorrienteOpAmp, ADC_11db); //El OpAmp satura a 3.670V con Vcc ~ 5V

  Serial.begin(115200);
  pinMode(LOCAL, OUTPUT);
  pinMode(SIMULINK, OUTPUT);
  pinMode(EnableVent, OUTPUT);
  digitalWrite(EnableVent, HIGH);

  inicializaLcd();                  // Incialización del display
  incializaRotaryEncoder();         //Incialización encoder rotativo HW-040 

  myEnc.attachHalfQuad(encoderA, encoderB);
  myEnc.setCount(0);

  setupMovement();                // Incializacion Pines Motor
  myPID.SetSampleTime(20);
  myPID.SetOutputLimits(-255, 255);

  if(sys.estado==PARO) myPID.SetMode(MANUAL);
  else myPID.SetMode(AUTOMATIC);
  
  escribeLcd(" UNIVERSIDAD DE","   VALLADOLID");
  delay(1000);
  escribeLcd("   ESCUELA DE","INGENIERIAS(EII)");
  delay(1000);
  escribeLcd("Estado: "+stringEstado[sys.estado],stringControl[sys.control]+": "+stringEntrada[sys.entrada]);
  t0 = millis();
}

void loop() 
{
  if(botonEncoderPulsado()) menuPrincipal();
  if(sys.estado==MARCHA)
  {
    tactual = millis()-t0;
    CargaExterna();

    if(sys.control==VELOCIDAD)  controlVelocidad();
    else if (sys.control==POSICION) controlPosicion(); //Sólo diseñado para LOCAL

    if(sys.tipoPID == PID_SIMULINK) //Transmisión sólo para Simulink
    {
     Transmision();
     if(tactual-tanterior > 1000)
      {
       sys.estado = PARO;
       escribeLcd("ERROR SIMULACION","   PULSE: RUN"); //Desconexión de la maqueta si no está comunicando con simulink
      }
    } 
  }
  
  else if(sys.estado==PARO)
  {
    tanterior = millis()-t0; //Para poder reanudar la marcha en cualquier instante
    myPID.SetMode(MANUAL);
    Motor(0, sys.frenoDinamico);
  }
 
  switch(sys.tipoPID)
  {
    case 0: digitalWrite(LOCAL, HIGH);
            digitalWrite(SIMULINK, LOW);break;
    case 1: digitalWrite(LOCAL, LOW);
            digitalWrite(SIMULINK, HIGH);break;
    case 2: digitalWrite(LOCAL, LOW);
            digitalWrite(SIMULINK, LOW);break;
  }
}

void CargaExterna()
{
  if(sys.frenoDinamico == true) //Código para generar freno dinámico aplicando tensión lógica a ambas direcciones del motor
   {
    SIM_TorqueCarga.number = 0.0044*tension;

    if(millis()-t_freno> 5000)
    {
      sys.frenoDinamico = false;
      SIM_TorqueCarga.number = 0;
    }
   }
   else
   {
    t_freno = millis();
   }
}   

void Transmision()
{
  //Recibo Simulink
  getFloats();
  // Envio variables a simulink
  SIM_Tiempo.number = TiempoReal(); 
  SIM_TipoControl.number = sys.control;
  SIM_TipoPID.number = sys.tipoPID;
  SIM_Encoder.number = Input;
  SIM_Corriente.number = MedirCorriente(); //Corriente en mA
  SIM_Tension.number = tension; //Valor de tensión desde la maqueta

  //Trama para enviar todos los paquetes
  Serial.write('A'); 
  // Print float data
  for (int i=0; i<4; i++)
  {
    Serial.write(SIM_Tiempo.bytes[i]); 
  }
  for (int i=0; i<4; i++)
  {
    Serial.write(SIM_TipoControl.bytes[i]); 
  }
  for (int i=0; i<4; i++)
  {
    Serial.write(SIM_TipoPID.bytes[i]); 
  }
  for (int i=0; i<4; i++)
  {
    Serial.write(SIM_Encoder.bytes[i]); 
  }
  for (int i=0; i<4; i++)
  {
    Serial.write(SIM_Corriente.bytes[i]); 
  }
  for (int i=0; i<4; i++)
  {
    Serial.write(SIM_Tension.bytes[i]); 
  }
  for (int i=0; i<4; i++)
  {
    Serial.write(SIM_TorqueCarga.bytes[i]); 
  }
  // Print terminator
  Serial.print('\n');
  delay(20);
  // Use the same delay in the Serial Receive block
}

float MedirCorriente()
{
  int lecturaADC = 0;
  long suma = 0;
  const int muestras = 64;

  // Promedio para reducir ruido
  for (int i = 0; i < muestras; i++) 
  {
    suma += analogRead(CorrienteOpAmp);
  }
  lecturaADC = suma / muestras;

  // Convertir a tensión en la entrada del ESP32
  float voltajeLeido = (lecturaADC * VREF) / ADC_MAX;

  // Retrocalcular la tensión original en el shunt
  float voltajeShunt = voltajeLeido / GANANCIA;

  // Calcular corriente según ley de Ohm (I = V / R) en mA
  float corriente = voltajeShunt * 1000 / SHUNT_OHMIOS;

  // === SI LA CORRIENTE SUPERA UMBRAL, CAMBIAMOS A LECTURA DIRECTA ===
  if (abs(corriente) > 66.0) 
  {
    suma = 0;
    for (int i = 0; i < muestras; i++) 
    {
      suma += analogRead(CorrienteShunt);
    }
    lecturaADC = suma / muestras;
    voltajeShunt = (lecturaADC * VREF) / ADC_MAX; // ahora sin amplificación
    float corrienteDirecta = (voltajeShunt * 1000) / SHUNT_OHMIOS;
    corriente = corriente + corrienteDirecta;
  }

  if(sys.tipoPID != 2)
  {
    if(tension < 0)
    {
    corriente = -corriente;
    }
  }
  else
  {
    if(sys.Tension < 0)
    {
    corriente = -corriente;
    }
  }
  return corriente;
}

float TiempoReal() //Función para realizar entrada escalón ideal (pendiente infinita)
{
    if((abs(tensionAnterior-tension)>0)&&(sys.entrada==ESCALON))
    {
      temp = tanterior;
    }
    else
    {
      temp = tactual;
    }

   if (isnan(tension))
   tension = tensionAnterior; //o último valor válido
   else
   tensionAnterior = tension;

   return temp/1000;
}

void controlVelocidad()
{
  unsigned long int t, dt=100; // intervalo para el calculo de velocidad
  float tiempo;
  int8_t inc;
  double Pos; 
  
  static double Pos_ant = myEnc.getCount();
  
  //float periodo;
  static unsigned long int tinicio=millis();
  static unsigned long int t_ant=millis();  // Temporizador para calculo velocidad
  static unsigned long int t_ant2=millis();// Temporizador para calculo Periodo

  if(sys.tipoPID == PID_SIMULINK)
  {
   if(ElegirEntradas.number)
   {
    tension = ReferenciaTension.number;
   }
   else
   {
    tension = sys.Tension;
   }
  }

// Calculo velocidad 
  t=millis();

  if(t-t_ant> dt)
  {
    Pos= myEnc.getCount();
    Input=(double)1000*(Pos-Pos_ant)*60/((t-t_ant)*PPR);  // Calculo la velocidad en RPM
    t_ant=t;
    Pos_ant=Pos;
    switch(sys.tipoPID)
    {
      case 0: 
      Serial.print("+SetPoint(RPM):"+String(Setpoint));
      Serial.print(", ");
      if(sys.entrada==ESCALON)
      {
       Serial.print("SetPoint(RPM):"+String(-Setpoint));
       Serial.print(", "); 
      }
      Serial.print("VelocidadReal(RPM):"+String(Input));
      Serial.print(", ");
      Serial.println("ValorPID(0-255):"+String(Output));
      Serial.print(", ");
      Serial.println("Corriente(mA):"+String(MedirCorriente(), 2));
      escribeLcd1(stringEstado[sys.estado]+":"+String(Input)+"RPM");break;

      case 1: //escribeLcd(stringEstado[sys.estado]+":"+String(Input)+"RPM", stringEntrada[sys.entrada]+":"+String(tension)+"V");break;
              escribeLcd(stringEntrada[sys.entrada]+":"+String(Input)+"RPM"/*+" t:"+String(SIM_Tiempo.number)+"s"*/, String(tension)+"V "+String(MedirCorriente(), 2)+"mA");break;

      case 2:
      Serial.print("+RefTension(V):"+String(sys.Tension));
      Serial.print(", ");
      /*if(sys.entrada==ESCALON)
      {
       Serial.print("RefTension(V):"+String(-sys.Tension));
       Serial.print(", "); 
      }*/
      Serial.print("VelocidadReal(RPM):"+String(Input));
      Serial.print(", ");
      Serial.println("Corriente(mA):"+String(MedirCorriente(), 2));
      escribeLcd(stringEntrada[sys.entrada]+":"+String(Input)+"RPM", String(sys.Tension)+"V "+String(MedirCorriente(), 2)+"mA");break;
    }
  }
  if(sys.entrada==ESCALON)
  {
     inc=deltaEncoder();
     if(sys.tipoPID == 0)
     {
      if(inc!=0) Setpoint=(Setpoint>0?Setpoint+inc:Setpoint-inc); // Puedo cambiar la referencia con el rotary encoder
      if(t-t_ant2>sys.periodo*1000)
      {        // Cambio sentido
       Setpoint=-Setpoint;
       t_ant2=t; 
      }
     }
     else
     {
      if(inc!=0) sys.Tension=(sys.Tension>0?sys.Tension+inc:sys.Tension-inc); // Puedo cambiar la referencia con el rotary encoder
      if(sys.Tension>12)sys.Tension=sys.Tension-inc;
      if(sys.Tension<-12)sys.Tension=sys.Tension+inc;
      if(t-t_ant2>sys.periodo*1000)
      {        // Cambio sentido
       sys.Tension=-sys.Tension;
       t_ant2=t; 
      }
     }
  }
  else if(sys.entrada==CONST) //Valor constante, variable con el encoder
  {
    inc=deltaEncoder();
    if(sys.tipoPID == 0)
    {
      if(inc!=0) Setpoint=(Setpoint>0?Setpoint+inc:Setpoint-inc); // Puedo cambiar la referencia con el rotary encoder
      if(Setpoint>12)Setpoint=Setpoint-inc;
      if(Setpoint<-12)Setpoint=Setpoint+inc;
    }
    else
     {
      if(inc!=0) sys.Tension=(sys.Tension>0?sys.Tension+inc:sys.Tension-inc); // Puedo cambiar la referencia con el rotary encoder
      if(sys.Tension>12)sys.Tension=sys.Tension-inc;
      if(sys.Tension<-12)sys.Tension=sys.Tension+inc;
     }
  }
  else if(sys.entrada==SENO)
  {
   tiempo=(float)(millis()-tinicio);

   if(sys.tipoPID == 0)
   Setpoint = sys.setPoint*sin(2*PI*tiempo/(2*sys.periodo*1000)+PI);
   else
   {
    sys.Tension = 12*sin(2*PI*tiempo/(2*sys.periodo*1000)+PI);
   }
  }
  else if(sys.entrada==RAMPA)
  {
    tiempo=(float)(millis()-tinicio);

    // Convertir el tiempo actual en segundos
    float t_s = tiempo/1000.0;

    // Normalizar dentro de un ciclo
    float t_ciclo = fmod(t_s, sys.periodo);

    // Rampa lineal: va de 0 a 12 V durante un período
    float rampa = (t_ciclo/sys.periodo)*12.0;

    if(sys.tipoPID == 0) 
    Setpoint = (sys.setPoint/12.0)*rampa;  // Escalado si setPoint < 12
    else
    {
     sys.Tension = rampa;
    }
    //Setpoint=move(sys.setPoint, 1000, 800, 0.1); //double xd, double vmax, double a, double dt);
  }

  if(Setpoint - Input > 50 || Setpoint - Input <-50)
  {
      Kp=sys.kPZMVel; //0.1
      Ki=sys.kIZMVel; //0.9
      Kd=sys.kDZMVel; //0
  }
  else 
  {
      Kp=sys.kPVel*0.1;// 0.01
      Ki=sys.kIVel*10; //3.5
      Kd=sys.kDVel*0.1; //0.2
  }
  myPID.SetTunings(Kp,Ki,Kd);
  myPID.Compute();
  
  switch(sys.tipoPID)
  {
    case 0:velMotor = Output;break;
    case 1:
    if(tension >= 0)
    {
      velMotor = map(tension, 0, 12, 0, 255);
    }
    else
    {
      velMotor = - map(abs(tension), 0, 12, 0, 255);
    };break;
    case 2:
    if(sys.Tension >= 0)
    {
      velMotor = map(sys.Tension, 0, 12, 0, 255);
    }
    else
    {
      velMotor = - map(abs(sys.Tension), 0, 12, 0, 255);
    };break;
  }
  Motor(velMotor, sys.frenoDinamico); 
}

void controlPosicion()
{
  float tiempo;
  unsigned long int t, dt=100; // intervalo para la visualización valores
  static unsigned long int tinicio=millis();  // Para calculo  funcion sinoidal
  static unsigned long int t_ant=millis();  // Temporizador para calculo velocidad
  static unsigned long int t_ant2=millis();// Temporizador para calculo Periodo
  //static int dir=1;

  t=millis();

    if(sys.entrada==ESCALON)
    {
    int8_t inc=deltaEncoder();
    if(inc!=0) Setpoint=(Setpoint>0?Setpoint+inc:Setpoint-inc); // Puedo cambiara la referencia con el rotary encoder

    if(t-t_ant2>sys.periodo*1000)
    {        // Cambio sentido
        Setpoint=-Setpoint;
        t_ant2=t; 
    }
    
  }
  else if(sys.entrada==CONST)
  {
      int8_t inc=deltaEncoder();
      if(inc!=0) 
      {
        if(sys.tipoPID == 0)
        {
          //Setpoint+=inc*10;
          if(inc!=0) Setpoint=(Setpoint>0?Setpoint+inc:Setpoint-inc); // Puedo cambiar la referencia con el rotary encoder
          if(Setpoint>12)Setpoint=Setpoint-inc;
          if(Setpoint<-12)Setpoint=Setpoint+inc;
        }
        else
         {
           if(inc!=0) sys.Tension=(sys.Tension>0?sys.Tension+inc:sys.Tension-inc); // Puedo cambiar la referencia con el rotary encoder
           if(sys.Tension>12)sys.Tension=sys.Tension-inc;
           if(sys.Tension<-12)sys.Tension=sys.Tension+inc;
         } // cada pulso se multiplica *10 para cambios más rápidos
      }   
  }
  else if(sys.entrada==SENO)
  {
      tiempo=(float)(millis()-tinicio);
      Setpoint = sys.setPoint*sin(2*PI*tiempo/(2*sys.periodo*1000)+PI)-200;
      
  }
  else if(sys.entrada==RAMPA)
  {
      if((abs(Setpoint-sys.setPoint))==0)
      { // Si se alcanza el destino cambia la posicion
            sys.setPoint=-sys.setPoint;
      }       
      Setpoint=move(sys.setPoint, 1000, 800, 0.1); //double xd, double vmax, double a, double dt);
  }
  //Input = myEnc.read(); // Lee encoder del motor
  //Input = myEnc.readEncoder();;
  Input = myEnc.getCount();
  if(Output<140 || Output>-140)
  {
      Kp=sys.kPZMPos*0.1; //3
      Ki=sys.kIZMPos*0.1; //0.05
      Kd=sys.kDZMPos*0.1; //0.0
  }
  else
  {
    Kp=sys.kPPos*0.1; //0.76
    Ki=sys.kIPos*0.1; //0.05
    Kd=sys.kDPos*0.1; //0.05
  }
  
  myPID.SetTunings(Kp,Ki,Kd);
  myPID.Compute();
  
  if(t-t_ant> dt && sys.entrada!=RAMPA)
  { /*                                     // Imprime valores cada periodo de muestreo
    Serial.print("+SetPoint:"+String(Setpoint));
    Serial.print(", ");
    if(sys.entrada==ESCALON)
    {
      Serial.print("SetPoint:"+String(-Setpoint));
      Serial.print(", "); 
    }
    Serial.print("Input:"+String(Input));
    Serial.print(", ");
    Serial.println("Output:"+String(Output));
    Serial.print(", ");
    Serial.print("Corriente:"+String(MedirCorriente()));*/
    escribeLcd1(stringEstado[sys.estado]+": "+String(Input));
    t_ant=t;
  }

  if(sys.tipoPID == 0)
  {
    velMotor=Output; //Cambiar signo si el motor gira solo en un sentido
  }

  Motor(velMotor, sys.frenoDinamico);
}

double  move(double xd, double vmax, double a, double dt)
{
  static unsigned long int t_ant=millis();
 
  static double v,x,x_ant=myEnc.getCount();
  unsigned long int t;
  int sentido_giro;
  
  x=myEnc.getCount();
  t=millis();
  if(t-t_ant>dt*1000){
      
      t_ant=t;
      sentido_giro=(xd-x>0?1:-1);
  
  
    if(abs(xd-x) >2*vmax*vmax*dt/a){
    //if(abs(xd-x) >500){
      if(abs(v) < vmax){      // Acelero
          x=x+v*dt+0.5*a*dt*dt*sentido_giro;
          v=v+a*dt*sentido_giro;
          Serial.println("Acelero");
      }
      else{
          v=vmax*sentido_giro;
          x=x+v*dt;        // Vel constante
          Serial.println("Vel constante");
      }
   }
   else{                            // Decelero
       x=x+v*dt-0.5*a*dt*dt*sentido_giro;
        v=v-a*dt*sentido_giro;
       if((xd-x)*sentido_giro<0){
          x=xd;    // Comprobamos no pasarnos  
          v=0;
       }
       Serial.println("Decelero");
   }  
    Serial.print("xd:"+String(xd));
    Serial.print(", ");
    Serial.print("x:"+String(x));
    Serial.print(", ");
    Serial.print("Input:"+String((int32_t)myEnc.getCount()));
    Serial.print(", ");
    Serial.println("v:"+String(v));
  }
 return x;
}

  
